<?php
/**
 * Tags
 *
 * @package     AutomatorWP\User Lists\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Friendship tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_user_lists_get_list_tags() {

    return array(
        'list_id' => array(
            'label'     => __( 'List ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '123',
        ),
        'list_name' => array(
            'label'     => __( 'List name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'Subscribers',
        ),
    );

}

/**
 * Custom action response tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $action         The action object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last action log object
 *
 * @return string
 */
function automatorwp_user_lists_get_trigger_list_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'user_lists' ) {
        return $replacement;
    }

    $list_id = automatorwp_get_log_meta( $log->id, 'list_id', true );
    $list = automatorwp_user_lists_get_list_by_id( $list_id );
    
    switch( $tag_name ) {
        case 'list_id':
            $replacement = $list->id;
            break;
        case 'list_name':
            $replacement = $list->name;
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_user_lists_get_trigger_list_tag_replacement', 10, 6 );
